# Version 10 Informationsklasser och -typer i LEFI och LEKA

> OBS! Mer information och eventuella korrigeringar av dokumentation kommer att finnas så fort som vi gör första release
> version av kontraktet.

## OpenAPI

LEFI använder OpenAPI dokumentation för att dokumentera hur man kommunicerar med tjänsten. För att inte behöva göra en
ny tjänst varje gång en ändring sker inom Försäkringskassans och Pensionsmyndighetens socialförsäkringsförmåner. Har
vi valt att ändra på några saker för att öka flexibiliteten av OpenAPI.

Första saken är du som konsument av LEFI får inte anta att objekt är stängda för utökning i frånvaro av
`additionalProperties` deklaration och måste ignorera fält skickade av oss vilket man inte kan hantera.[^1]

Andra saken är du som konsument av LEFI måste vara beredd att nya värden kan komma i `x-extensible-enum`. Antingen var
agnostiker eller förse ett standard betenende för okända värden. (Det här betyder att du inte bara kan implementera det
men en stängd enumeration typ som Javas `enum`.)[^1]

Tredje saken är du som konsument av LEFI måste vara beredd att hantera HTTP status koder som inte är specifierade i en
endpoint definitions.

[^1]: Information om förändringar kommer informeras i förväg innan information flyttas eller läggs till. Men du som
konsument måste fortfarande kunna hantera depriveringen.

## Informationsklasser

Det finns 6 informationsklasser i nuläget, vilka är

1. _förmånsinformation_,
2. _anspråk_,
3. _beslut_,
4. _utbetalningar_,
5. _preliminära utbetalningar_, samt
6. _övrig information_.

Klassen __förmånsinformation__ används för att referera till ärende- och beslutsinformation som följer LEFI Onlines
gamla informationsmodell. Denna informationsmodell har vid lansering av LEFI Online version 9 enbart delvis frångåtts,
vilket är anledningen till att klassen existerar parallellt med klasserna __anspråk__ och __beslut__. Dessa tre klasser
används alltså för att referera till information som uppkommit under handläggningsprocesserna associerade med
Försäkringskassans och Pensionsmyndighetens socialförsäkringsförmåner.

Klasserna __preliminära utbetalningar__ och __utbetalningar__ används istället för att referera till _schemalagda_
respektive _redan exekverade_ utbetalningar som gjorts aktuella av den handläggning som refereras till av de tre första
klasserna.

Den sista klassen, __övrig information__, inkluderar alla uppgifter som inte faller under de andra klasserna.

## Informationstyper

En informationstyp refererar till den information som är associerad med en specifik försäkringsförmån eller övrig
uppgift. De informationstyper som refererar till försäkringsinformation kallas för __förmånsgrupper__, medan de som
refererar till övriga uppgifter kallas för __övriga informationtyper__.

Varje informationstyp representeras av en kod, vilken har ett prefix (`FK` repsektive `PM`) som indikerar vilken
myndighet det är som lämnar ut informationen associerad med gruppen.

Vissa av informationstyperna existerar enbart av historiska skäl och kommer inte att förmedlas via LEFI Online version
9, även om de har sina egna koder. En huvudanledning till detta är att Pensionsmyndigheten i samband med lanseringen av
version 9 tar över ansvaret att förvalta sin egen information, och att denna information i en övergångsfas finns i både
Försäkringskassans och Pensionsmyndighetens system. Vilka förmånsgrupper som kommer att finnas tillgängliga under LEFI
Online version 9:s livstid beskrivs dock inte i den här dokumentationen, vilken är främst riktad till utvecklare. Fler
detaljer kring ämnet bör dock finnas i den verksamhetsmässiga dokumentationen för LEFI Online version 9.

### Förmånsgrupper

I skrivande stund finns följande förmånsgrupper:

1. _Allmänt barnbidrag_ (`FK:ABB`),
3. _Arbetsskadelivränta_ (`FK:AL`),
4. _Aktivitetsstöd_ (`FK:AS`),
5. _Bostadsbidrag_ (`FK:BOB`),
6. _Bostadstillägg_ (`FK:BST`),
7. _Barntillägg_ (`FK:BTI`),
8. _Dagpenning till totalförsvarspliktiga_ (`FK:DPE`),
9. _Etableringsjobb_ (`FK:EJO`),
10. _Etableringstillägg_ (`FK:ET`),
11. _Föräldrapenning_ (`FK:FP`),
12. _Förebyggande sjukpenning_ (`FK:FSJP`),
13. _Graviditetspenning_ (`FK:GP`),
14. _Handikappersättning_ (`FK:HE`),
15. _Mottagare av barnbidrag_ (`FK:MABB`),
16. _Merkostnadsersättning_ (`FK:MEK`),
17. _Närståendepenning_ (`FK:NP`),
18. _Omvårdnadsbidrag_ (`FK:OMV`),
19. _Programjobdagar_ (`FK:PJOB`),
20. _Programersättning_ (`FK:PROG`),
21. _Rehabiliteringsersättning_ (`FK:RBE`),
22. _Sjuk- och aktivitetsersättning_ (`FK:SA`),
23. _Smittbärarersättning_ (`FK:SBP`),
24. _Sjukpenning_ (`FK:SJP`),
25. _Tillällig föräldrapenning_ (`FK:TFP`),
26. _Underhållsstöd_ (`FK:US`),
27. _Vårdbidrag_ (`FK:VB`),
28. _Yrkesskadelivränta_ (`FK:YL`),
29. _Allmän pension utan ÅP37_ (`PM:AP`),
30. _Bostads- och inkomststöd_ (`PM:BTI`), samt
31. _Efterlevandeförmåner_ (`PM:EF`).

### Övriga informationstyper

I skrivande stund finns följande typer av övrig information:

1. _Generell personinformation_ (`FK:GEPI`),
2. _Programanvisning_ (`FK:PANV`),
3. _Sjukpenninggrundande inkomst_ (`FK:SGI`),
4. _Skatteuppgift_ (`FK:SKUP`),
5. _Studiemedelsavisering_ (`FK:STAV`),
6. _Levnadsintyg_ (`PM:LINT`),
7. _Pensionsbehållning_ (`PM:PBH`), samt
8. _Pensionsunderlag_ (`PM:PU`).

## Informationshämtning

Vid uthämtning av förmånsinformation uppges vilka informationstyper som är av intresse under respektive
informationsklass. En [aktör](AKTOR.md) som hämtar ut förmånsinformation om en person kan, exempelvis, vilja ha
_anspråk_, _beslut_ och _utbetalningar_ associerade med förmånsgruppen _efterlevandeförmåner_. Dessutom kan aktören
vilja ha _personinformation_ och _levnadsintyg_ för samma person, vilka båda är exempel på övrig information.

Då informationsklasser och -typer delar upp LEFI Onlines information på olika plan kan kombinationen av dessa
grupperingar användas för att ge en relativt exakt beskrivning av vilken information som önskas vid hämtning.

För att få en bättre uppfattning av hur informationsklasser och -typer används tillsammans i praktiken bör
API-specifikationerna i mappen `openapi/` studeras.
