
# OBS! Testmiljön för version 10 är inte på plats än. 
# Följande är instruktionerna för att köra mot version 9 f.n.
# Försäkringskassans Leverera förmånsinformation (LEFI) - Testmiljö

E-tjänsten _Leverera förmånsinformation_ (LEFI) låter anslutna [aktörer](AKTOR.md) begära ut information om Försäkringskassans och Pensionsmyndighetens kunders ärenden och uppgifter. Det här arkivet samlar den information som behövs för att fysiskt ansluta till och nyttja Försäkringskassans testmiljö för LEFI, vilken inkluderar API-specifikationer, URL:er och beskrivningar.

Mer information om LEFI hittar du på https://www.forsakringskassan.se/myndigheter-och-samarbetspartner/e-tjanster-for-myndigheter-och-samarbetspartner/lefi-online.

## Innehållsförteckning
1. Tjänstebeskrivning
    - 1.1 Förmånsinformation
2. Miljöbeskrivning
    - 2.1 Anslutning
    - 2.2 Begränsningar
    - 2.3 Testdata
    - 2.4 Specialfall

## 1. Tjänstebeskrivning

LEFI låter en ansluten [aktör](AKTOR.md), såsom ett försäkringsbolag, en kommun, eller en avdelning på en kommun, att hämta information om ärenden eller andra uppgifter om Försäkringskassans kunder.
Olika aktörer har olika rättsliga förutsättningar för att ta begära och ta emot denna information. Av den anledningen låter e-tjänsten också respektive aktör att hämta en sammanställning av vilka klasser och typer av förmånsinformation denne har rätt till.

[LEFI]: https://www.forsakringskassan.se/myndigheter-och-samarbetspartner/e-tjanster-for-myndigheter-och-samarbetspartner/lefi-online

Förmånsinformation och tillgängliga informationstyper hämtas via det HTTP-baserade gränssnitt som beskrivs i det följande underavsnittet. Tjänstens _OpenAPI-specifikation_, vilken är en programmatisk beskrivning av gränssnittets operationer och datatyper, finns att hitta i mappen `openapi/`.

### 1.1 Förmånsinformation

Gränssnittet tillhandahåller två operationer, en för att _hämta tillgängliga informationstyper_ och en för att _hämta förmånsinformation_. Den första operationen används för att ta reda på vilka [klasser och typer av information](INFORMATIONSTYP.md) en aktuell aktör _kan_ begära ut. En delmängd av dessa klasser och typer kan sedan tillhandahållas den andra operationen för att hämta den förmånsinformation som önskas och finns att tillgå.

Specificeras en informationstyp i en hämtningsfråga som inte en aktör har rätt till underkänns frågan och inget svar skickas tillbaka. Notera att i tidigare versioner av LEFI Online ignorerades istället typer av information där rättigheter saknades. Möjligheten att begära ut listor med tillgängliga typer av information är också nytt för LEFI version 9.

## 2. Miljöbeskrivning

LEFI:s testmiljö existerar enbart för att anslutna organisationer ska kunna utvärdera om deras integrationer fungerar tillsammans med LEFI:s gränssnitt. För att miljön ska kunna tjäna detta syfte har vissa begränsningar och specialanpassningar gjorts, vilka särskiljer den från produktionsmiljön.

I följande underavsnitt beskrivs hur en organisation ansluter till testmiljön, samt vilka begränsningar och specialanpassningar som gjorts.

### 2.1 Anslutning

Nyttjande av LEFI:s testmiljö kräver att en HTTPS-klient används som är konfigurerad att använda ett klient-certifikat som godkänns av Försäkringskassan. Instruktioner om hur ett godkänt certifikat erhålls, samt vilka certifikat som måste betraktas som betrodda, finns på [websidan för LEFI Online][LEFI].

#### 2.1.1 Gränssnittens URL:er

När ett godkänt certifikat är på plats (och HTTPS-klienten i fråga är konfigurerad att använda det med mTLS) ska följande bas-URL:er användas för att skicka meddelanden till de båda gränssnitten.

| Gränssnitt    | Bas-URL                                                                             |
|:--------------|:------------------------------------------------------------------------------------|
| LEFI Online | https://shsext.forsakringskassan.se:8200/rest/FK.EXI.LevereraFormansinformation.V9/ |

En bas-URL är alltså en URL som saknar sökvägen från en specifik API-operation. För att, exempelvis, skicka ett meddelande till aviseringsgränssnittets operation `hamtaFormansinformation`, vilken har sökvägen `/lefi-extern-formansinformation/v9/aktorer/{aktorsId}/formansinformation/fraga`, måste följande sökväg användas:

```
https://shsext.forsakringskassan.se:8200/rest/FK.EXI.LevereraFormansinformation.V9/lefi-extern-formansinformation/v9/aktorer/{aktorsId}/formansinformation/fraga
```

URL-schemat och -auktoriteten som används av samtliga utav testmiljöns operationer är alltså `https://shsext.forsakringskassan.se:8200/rest`. Denna typ av URL referas också till som _inlämningsadress_ i övrig dokumentation för LEFI Online.

#### 2.1.2 Header "Content-Type"

Kontrollera att headern ’Content-Type: application/json’ är satt i anropet till tjänsten, annars går det fel redan i integrationen.

### 2.2 Begränsningar

#### 2.2.1 Begränsad persistens

Testmiljön kan återställas till sitt ursprungliga skick när som helst, även om det i praktiken inte lär ske oftare än en gång om dygnet.

#### 2.2.2 Begränsad tillgänglighet

Testmiljön bör finnas tillgänglig mellan klockan 08:00 till 17:00 under vanliga vardagar. Den kan vara otillgänglig i kortare perioder under denna tid på grund utav uppgraderingar, omstarter och oförutsedda händelser. Testmiljön _kan_ finnas tillgänglig övrig tid.

#### 2.2.3 Ingen behörighetskontroll

Produktionsmiljön tillämpar olika regelverk för utlämnanande för respektive typ av ansluten organisation. Regelverken avgör vilka organisationer som har rätt att ta emot information om vilka förmåner. _Dock sker ingen tillämpning av regelverk i testmiljön_. Det betyder att samtliga organisationer har rätt till all information om alla förmåner, även om de inte har det i produktionsmiljön.

[### 2.3 Testdata](fk-lefi-v9-test.md)

Följande testpersoner och tillhörande testdata finns inlagda i testmiljön för närvarande. Observera att frågan för att hämta förmåner för de olika personer har ställts med verierade organisationer och behörigheter vilket betyder att för vissa av dessa förmåner har man fått avvikelse tillbaka i svaret vilket följer det verkliga scenariot.
Två av dessa testpersoner, dvs. 191212121212 och 198605202384 har mest data i svaren. Svaren som vi har samlat för de olika testpersoner är det som vi efter bästa förmåga kunnat samla in från olika testmiljöer.
Håll utkik efter uppdateringar av [websidan för LEFI Online][LEFI], för det kommer att ske kontinuerliga uppdateringar av testpersoner i testmiljön.

__OBS! Null posterna filtreras i svaren både i testmiljö och produktionsmiljön.__

###  191212121212
####  FK förmåner:
	- generellPersoninformation
	- aktivitetsstodsarende
	- programanvisning
	- programjobdagar
	- programersattningsarende
	- arbetsskadeegenlivrantearende
	- barnbidragsarende
	- bostadsbidragsarende
	- bostadstillaggsarende
	- foraldrapenningarende
	- handikappersattningsarende
	- merkostnadsersattningsarende
	- narstaendepenningarende
	- omvardnadsbidragsarende
	- rehabersattningsarende
	- sjukOchAktivitetsersattningsarende
	- mottagareavbarnbidrag
	- sjukpenningarende
	- sjukpenninggrundandeInkomstuppgift
	- smittbararersattningsarende
	- studiemedelsavisering
	- tillfalligForaldrapenningarende
	- totalforsvarspliktsarende
	- underhallsstodskrav
	- utbetalningsuppgift
	- preliminarautbetalningar
	- vardbidragsarende
	- yrkesskadeegenlivrantearende
#####  PM förmåner:
	- Allmän pension
	- Bostads- och inkomststöd
	- Bostadstillägg
	- Tilläggspension
	- Inkomstpension
	- Premiepension
	- Garantipension
	- Inkomstpensionstillägg
	- Efterlevandeförmåner
	- Premiepension till efterlevande
	- Särskilt bostadstillägg
	- Äldreförsörjningsstöd
	- Änkepension

###  195001182046
####  FK förmåner:
	- generellPersoninformation
	- aktivitetsstodsarende
	- programanvisning
	- programjobdagar
	- programersattningsarende
	- arbetsskadeegenlivrantearende
	- barnbidragsarende
	- bostadsbidragsarende
	- bostadstillaggsarende
	- foraldrapenningarende
	- handikappersattningsarende
	- merkostnadsersattningsarende
	- narstaendepenningarende
	- omvardnadsbidragsarende
	- rehabersattningsarende
	- sjukOchAktivitetsersattningsarende
	- mottagareavbarnbidrag
	- sjukpenningarende
	- sjukpenninggrundandeInkomstuppgift
	- smittbararersattningsarende
	- studiemedelsavisering
	- tillfalligForaldrapenningarende
	- totalforsvarspliktsarende
	- underhallsstodskrav
	- utbetalningsuppgift
	- preliminarautbetalningar
	- vardbidragsarende
	- yrkesskadeegenlivrantearende
####  PM förmåner:
	- Allmän pension
	- Bostads- och inkomststöd
	- Bostadstillägg
	- Tilläggspension
	- Inkomstpension
	- Premiepension
	- Garantipension
	- Inkomstpensionstillägg
	- Särskilt bostadstillägg
	- Äldreförsörjningsstöd

###  195002192382
####  FK förmåner:
	- generellPersoninformation
	- aktivitetsstodsarende
	- programanvisning
	- programjobdagar
	- programersattningsarende
	- arbetsskadeegenlivrantearende
	- barnbidragsarende
	- bostadsbidragsarende
	- bostadstillaggsarende
	- foraldrapenningarende
	- handikappersattningsarende
	- merkostnadsersattningsarende
	- narstaendepenningarende
	- omvardnadsbidragsarende
	- rehabersattningsarende
	- sjukOchAktivitetsersattningsarende
	- mottagareavbarnbidrag
	- sjukpenningarende
	- sjukpenninggrundandeInkomstuppgift
	- smittbararersattningsarende
	- studiemedelsavisering
	- tillfalligForaldrapenningarende
	- totalforsvarspliktsarende
	- underhallsstodskrav
	- utbetalningsuppgift
	- preliminarautbetalningar
	- vardbidragsarende
	- yrkesskadeegenlivrantearende
####  PM förmåner:
	- Allmän pension
	- Bostads- och inkomststöd
	- Bostadstillägg
	- Tilläggspension
	- Inkomstpension
	- Premiepension
	- Garantipension
	- Inkomstpensionstillägg
	- Särskilt bostadstillägg
	- Äldreförsörjningsstöd

###  195004112354
####  FK förmåner:
	- generellPersoninformation
	- aktivitetsstodsarende
	- programanvisning
	- programjobdagar
	- programersattningsarende
	- arbetsskadeegenlivrantearende
	- barnbidragsarende
	- bostadsbidragsarende
	- bostadstillaggsarende
	- foraldrapenningarende
	- handikappersattningsarende
	- merkostnadsersattningsarende
	- narstaendepenningarende
	- omvardnadsbidragsarende
	- rehabersattningsarende
	- sjukOchAktivitetsersattningsarende
	- mottagareavbarnbidrag
	- sjukpenningarende
	- sjukpenninggrundandeInkomstuppgift
	- smittbararersattningsarende
	- studiemedelsavisering
	- tillfalligForaldrapenningarende
	- totalforsvarspliktsarende
	- underhallsstodskrav
	- utbetalningsuppgift
	- preliminarautbetalningar
	- vardbidragsarende
	- yrkesskadeegenlivrantearende
####  PM förmåner:
	- Allmän pension
	- Bostads- och inkomststöd
	- Bostadstillägg
	- Tilläggspension
	- Inkomstpension
	- Premiepension
	- Garantipension
	- Inkomstpensionstillägg
	- Särskilt bostadstillägg
	- Äldreförsörjningsstöd

###  195701032863
####  FK förmåner:
	- generellPersoninformation
	- sjukpenningarende
	- sjukpenninggrundandeInkomstuppgift
####  PM förmåner:
	- Bostads- och inkomststöd
	- Bostadstillägg
	- Inkomstpension
	- Särskilt bostadstillägg
	- Äldreförsörjningsstöd

###  196106143495
####  FK förmåner:
####  PM förmåner:
	- Allmän pension
	- Bostads- och inkomststöd
	- Bostadstillägg
	- Tilläggspension
	- Inkomstpension
	- Premiepension
	- Garantipension
	- Inkomstpensionstillägg
	- Efterlevandeförmåner
	- Premiepension till efterlevande
	- Särskilt bostadstillägg
	- Äldreförsörjningsstöd
	- Änkepension

###  196407313607
####  FK förmåner:
	- generellPersoninformation
	- aktivitetsstodsarende
	- programanvisning
	- programjobdagar
	- programersattningsarende
	- barnbidragsarende
	- bostadsbidragsarende
	- bostadstillaggsarende
	- foraldrapenningarende
	- handikappersattningsarende
	- merkostnadsersattningsarende
	- narstaendepenningarende
	- omvardnadsbidragsarende
	- rehabersattningsarende
	- sjukOchAktivitetsersattningsarende
	- sjukpenningarende
	- sjukpenninggrundandeInkomstuppgift
	- smittbararersattningsarende
	- studiemedelsavisering
	- tillfalligForaldrapenningarende
	- totalforsvarspliktsarende
	- underhallsstodskrav
	- utbetalningsuppgift
	- preliminarautbetalningar
	- vardbidragsarende
####  PM förmåner:
	- Allmän pension
	- Bostads- och inkomststöd
	- Bostadstillägg
	- Tilläggspension
	- Inkomstpension
	- Premiepension
	- Garantipension
	- Inkomstpensionstillägg
	- Efterlevandeförmåner
	- Särskilt bostadstillägg
	- Äldreförsörjningsstöd
	- Änkepension

###  196810016722
####  FK förmåner:
	- generellPersoninformation
	- aktivitetsstodsarende
	- programanvisning
	- programjobdagar
	- programersattningsarende
	- barnbidragsarende
	- bostadsbidragsarende
	- bostadstillaggsarende
	- handikappersattningsarende
	- rehabersattningsarende
	- sjukOchAktivitetsersattningsarende
	- sjukpenningarende
	- sjukpenninggrundandeInkomstuppgift
	- smittbararersattningsarende
	- studiemedelsavisering
	- tillfalligForaldrapenningarende
	- underhallsstodskrav
	- utbetalningsuppgift
	- preliminarautbetalningar
	- vardbidragsarende
	- yrkesskadeegenlivrantearende
####  PM förmåner:
	- Allmän pension
	- Bostads- och inkomststöd
	- Bostadstillägg
	- Tilläggspension
	- Inkomstpension
	- Premiepension
	- Garantipension
	- Inkomstpensionstillägg
	- Efterlevandeförmåner
	- Premiepension till efterlevande
	- Särskilt bostadstillägg
	- Äldreförsörjningsstöd
	- Änkepension

###  196810016723
####  FK förmåner:
	- programersattningsarende
	- preliminarautbetalningar
####  PM förmåner:

###  196907289299
####  FK förmåner:
	- generellPersoninformation
	- aktivitetsstodsarende
	- programanvisning
	- programjobdagar
	- programersattningsarende
	- arbetsskadeegenlivrantearende
	- barnbidragsarende
	- bostadsbidragsarende
	- bostadstillaggsarende
	- foraldrapenningarende
	- handikappersattningsarende
	- merkostnadsersattningsarende
	- narstaendepenningarende
	- omvardnadsbidragsarende
	- rehabersattningsarende
	- sjukOchAktivitetsersattningsarende
	- mottagareavbarnbidrag
	- sjukpenningarende
	- sjukpenninggrundandeInkomstuppgift
	- smittbararersattningsarende
	- studiemedelsavisering
	- tillfalligForaldrapenningarende
	- totalforsvarspliktsarende
	- underhallsstodskrav
	- utbetalningsuppgift
	- preliminarautbetalningar
	- vardbidragsarende
	- yrkesskadeegenlivrantearende
####  PM förmåner:
	- Allmän pension
	- Bostads- och inkomststöd
	- Bostadstillägg
	- Tilläggspension
	- Inkomstpension
	- Premiepension
	- Garantipension
	- Inkomstpensionstillägg
	- Efterlevandeförmåner
	- Premiepension till efterlevande
	- Särskilt bostadstillägg
	- Äldreförsörjningsstöd
	- Änkepension

###  197110089294
####  FK förmåner:
	- generellPersoninformation
	- aktivitetsstodsarende
	- programanvisning
	- programjobdagar
	- programersattningsarende
	- arbetsskadeegenlivrantearende
	- barnbidragsarende
	- bostadsbidragsarende
	- bostadstillaggsarende
	- foraldrapenningarende
	- handikappersattningsarende
	- merkostnadsersattningsarende
	- narstaendepenningarende
	- omvardnadsbidragsarende
	- rehabersattningsarende
	- sjukOchAktivitetsersattningsarende
	- sjukpenningarende
	- sjukpenninggrundandeInkomstuppgift
	- smittbararersattningsarende
	- tillfalligForaldrapenningarende
	- totalforsvarspliktsarende
	- underhallsstodskrav
	- utbetalningsuppgift
	- preliminarautbetalningar
	- vardbidragsarende
	- yrkesskadeegenlivrantearende
####  PM förmåner:
	- Allmän pension
	- Bostads- och inkomststöd
	- Bostadstillägg
	- Tilläggspension
	- Inkomstpension
	- Premiepension
	- Garantipension
	- Inkomstpensionstillägg
	- Efterlevandeförmåner
	- Premiepension till efterlevande
	- Särskilt bostadstillägg
	- Äldreförsörjningsstöd
	- Änkepension

###  197311059286
####  FK förmåner:
	- generellPersoninformation
	- aktivitetsstodsarende
	- programanvisning
	- programjobdagar
	- programersattningsarende
	- arbetsskadeegenlivrantearende
	- barnbidragsarende
	- bostadsbidragsarende
	- bostadstillaggsarende
	- foraldrapenningarende
	- handikappersattningsarende
	- merkostnadsersattningsarende
	- narstaendepenningarende
	- omvardnadsbidragsarende
	- rehabersattningsarende
	- sjukOchAktivitetsersattningsarende
	- sjukpenningarende
	- sjukpenninggrundandeInkomstuppgift
	- smittbararersattningsarende
	- studiemedelsavisering
	- tillfalligForaldrapenningarende
	- totalforsvarspliktsarende
	- underhallsstodskrav
	- utbetalningsuppgift
	- preliminarautbetalningar
	- vardbidragsarende
	- yrkesskadeegenlivrantearende
####  PM förmåner:
	- Allmän pension
	- Bostads- och inkomststöd
	- Bostadstillägg
	- Tilläggspension
	- Inkomstpension
	- Premiepension
	- Garantipension
	- Inkomstpensionstillägg
	- Efterlevandeförmåner
	- Premiepension till efterlevande
	- Särskilt bostadstillägg
	- Äldreförsörjningsstöd
	- Änkepension

###  197604219423
####  FK förmåner:
	- generellPersoninformation
	- aktivitetsstodsarende
	- programanvisning
	- programjobdagar
	- programersattningsarende
	- arbetsskadeegenlivrantearende
	- barnbidragsarende
	- bostadsbidragsarende
	- bostadstillaggsarende
	- foraldrapenningarende
	- handikappersattningsarende
	- merkostnadsersattningsarende
	- narstaendepenningarende
	- omvardnadsbidragsarende
	- rehabersattningsarende
	- sjukOchAktivitetsersattningsarende
	- sjukpenningarende
	- sjukpenninggrundandeInkomstuppgift
	- smittbararersattningsarende
	- studiemedelsavisering
	- tillfalligForaldrapenningarende
	- totalforsvarspliktsarende
	- underhallsstodskrav
	- utbetalningsuppgift
	- preliminarautbetalningar
	- vardbidragsarende
	- yrkesskadeegenlivrantearende
####  PM förmåner:
	- Allmän pension
	- Bostads- och inkomststöd
	- Bostadstillägg
	- Tilläggspension
	- Inkomstpension
	- Premiepension
	- Garantipension
	- Inkomstpensionstillägg
	- Efterlevandeförmåner
	- Premiepension till efterlevande
	- Särskilt bostadstillägg
	- Äldreförsörjningsstöd
	- Änkepension

###  197912312381
####  FK förmåner:
	- bostadsbidragsarende
####  PM förmåner:
	- Allmän pension
	- Bostads- och inkomststöd
	- Bostadstillägg
	- Tilläggspension
	- Inkomstpension
	- Premiepension
	- Garantipension
	- Inkomstpensionstillägg
	- Efterlevandeförmåner
	- Premiepension till efterlevande
	- Särskilt bostadstillägg
	- Äldreförsörjningsstöd
	- Änkepension

###  198402167241
####  FK förmåner:
	- generellPersoninformation
	- barnbidragsarende
	- mottagareavbarnbidrag
	- utbetalningsuppgift
####  PM förmåner:

###  198403012738
####  FK förmåner:
	- generellPersoninformation
	- programanvisning
	- programjobdagar
	- programersattningsarende
	- handikappersattningsarende
	- merkostnadsersattningsarende
	- narstaendepenningarende
	- omvardnadsbidragsarende
	- mottagareavbarnbidrag
	- sjukpenninggrundandeInkomstuppgift
	- studiemedelsavisering
	- preliminarautbetalningar
####  PM förmåner:
	- Allmän pension
	- Bostads- och inkomststöd
	- Bostadstillägg
	- Tilläggspension
	- Inkomstpension
	- Premiepension
	- Garantipension
	- Inkomstpensionstillägg
	- Efterlevandeförmåner
	- Premiepension till efterlevande
	- Särskilt bostadstillägg
	- Äldreförsörjningsstöd
	- Änkepension

###  198405112395
####  FK förmåner:
	- generellPersoninformation
	- programanvisning
	- foraldrapenningarende
	- sjukpenninggrundandeInkomstuppgift
	- studiemedelsavisering
	- totalforsvarspliktsarende
	- preliminarautbetalningar
####  PM förmåner:
	- Allmän pension
	- Bostads- och inkomststöd
	- Bostadstillägg
	- Tilläggspension
	- Inkomstpension
	- Premiepension
	- Garantipension
	- Inkomstpensionstillägg
	- Efterlevandeförmåner
	- Premiepension till efterlevande
	- Särskilt bostadstillägg
	- Äldreförsörjningsstöd
	- Änkepension

###  198605202384
####  FK förmåner:
	- generellPersoninformation
	- aktivitetsstodsarende
	- programanvisning
	- programjobdagar
	- programersattningsarende
	- arbetsskadeegenlivrantearende
	- barnbidragsarende
	- bostadsbidragsarende
	- bostadstillaggsarende
	- foraldrapenningarende
	- handikappersattningsarende
	- merkostnadsersattningsarende
	- narstaendepenningarende
	- omvardnadsbidragsarende
	- rehabersattningsarende
	- sjukOchAktivitetsersattningsarende
	- mottagareavbarnbidrag
	- sjukpenningarende
	- sjukpenninggrundandeInkomstuppgift
	- smittbararersattningsarende
	- studiemedelsavisering
	- tillfalligForaldrapenningarende
	- totalforsvarspliktsarende
	- underhallsstodskrav
	- utbetalningsuppgift
	- preliminarautbetalningar
	- vardbidragsarende
	- yrkesskadeegenlivrantearende
####  PM förmåner:
	- Allmän pension
	- Bostads- och inkomststöd
	- Bostadstillägg
	- Tilläggspension
	- Inkomstpension
	- Premiepension
	- Garantipension
	- Inkomstpensionstillägg
	- Efterlevandeförmåner
	- Premiepension till efterlevande
	- Särskilt bostadstillägg
	- Äldreförsörjningsstöd
	- Änkepension

###  199001142398
####  FK förmåner:
	- generellPersoninformation
	- programanvisning
	- bostadsbidragsarende
	- bostadstillaggsarende
	- sjukpenninggrundandeInkomstuppgift
	- studiemedelsavisering
	- utbetalningsuppgift
####  PM förmåner:
	- Allmän pension
	- Bostads- och inkomststöd
	- Bostadstillägg
	- Tilläggspension
	- Inkomstpension
	- Premiepension
	- Garantipension
	- Inkomstpensionstillägg
	- Efterlevandeförmåner
	- Premiepension till efterlevande
	- Särskilt bostadstillägg
	- Äldreförsörjningsstöd
	- Änkepension

###  199809112387
####  FK förmåner:
	- generellPersoninformation
	- aktivitetsstodsarende
	- programanvisning
	- arbetsskadeegenlivrantearende
	- barnbidragsarende
	- sjukpenninggrundandeInkomstuppgift
	- studiemedelsavisering
	- utbetalningsuppgift
####  PM förmåner:
	- Allmän pension
	- Bostads- och inkomststöd
	- Bostadstillägg
	- Tilläggspension
	- Inkomstpension
	- Premiepension
	- Garantipension
	- Inkomstpensionstillägg
	- Efterlevandeförmåner
	- Premiepension till efterlevande
	- Särskilt bostadstillägg
	- Äldreförsörjningsstöd
	- Änkepension


### 2.4 Följande testpersoner kan anropas för att få 401 och 404 felkoder tillbaka:
| Testperson   | Felkod |
|:-------------|:-------|
| 201301222392 | 401    |
| 195101151818 | 404    |


              