const path = require("path");
const querystring = require("querystring");
const express = require("express");
const cors = require("cors");
const axios = require("axios");

const HTTP_PORT = 8010;

const app = express();
app.use(express.static(path.join(__dirname, "web")));
app.use(express.text({ type: "*/*" }));
app.use(cors());
app.set("views", path.join(__dirname, "web"));

app.get("/signal", (_, response) => {
    /* Metod för att ta emot signal från Försäkringskassan. Kommer tas bort. */
    response.status(200).end();
});

app.post("/submitForm", (request, response) => {
    const parsed = querystring.parse(request.body);
    const endpointCreate = `${parsed.baseUrl}/public/v1/erakning/create?kanal=1`;
    const endpointCreatePayload = {
        token: parsed.token,
        returnUrl: parsed.returnUrl,
        systemleverantorNamn: parsed.systemleverantorNamn,
        erakning:
            parsed.erakningData !== "" ? JSON.parse(parsed.erakningData) : {},
    };
    if (parsed.signalUrl !== "") {
        endpointCreatePayload.signalUrl = parsed.signalUrl;
    }

    console.log(
        `Anropar:\n${endpointCreate}\n\n${JSON.stringify(
            endpointCreatePayload,
            null,
            4,
        )}\n\n`,
    );
    const config = {};
    
    axios
        .post(endpointCreate, endpointCreatePayload, config)
        .then((responseCreate) => {
            console.log(
                `Svarade:\n${responseCreate.status}`,
                responseCreate.data,
            );

            const fingerprint = responseCreate.data.fingerprint;
            if (!fingerprint) {
                throw Error(`Fick inget fingerprint`);
            }
            const endpointStart = `${parsed.baseUrl}/public/v1/erakning/start?kanal=1&fingerprint=${fingerprint}`;
            console.log(`Svarar med redirect till:\n${endpointStart}`);
            response.redirect(endpointStart);
        })
        .catch((errorCreate) => {
            console.log(`Fel!`);
            let redirectUrl;
            if (errorCreate.response) {
                console.log(errorCreate.response.data);
                console.log(errorCreate.response.status);
                console.log(errorCreate.response.headers);
                redirectUrl = `/?error=${errorCreate}&data=${JSON.stringify(
                    errorCreate.response.data,
                )}`;
            } else {
                console.log(errorCreate);
                redirectUrl = `/?error=${errorCreate}`;
            }
            response.redirect(redirectUrl);
        });
});

app.listen(HTTP_PORT, () => {
    console.log(`Server listening on port: ${HTTP_PORT}.`);
});
