# Referensimplementation för E-RÄK

Tjänsten E-RÄK ska användas för att (1) den som har rätt till assistansersättning, (2) dennes vårdnadshavare eller (3) ställföreträdare ska kunna lämna uppgifter om utförd assistans. Du som är systemleverantör för elektroniska system kommer att kunna ansluta dig till tjänsten för att erbjuda tjänsten till assistansanordnare. Här publicerar vi teknisk beskrivning och information om support. Informationen riktar sig främst till dig som är teknisk kontaktperson hos en systemleverantör.

## Teknisk beskrivning av att skicka elektronisk räkning

Här beskrivs lösningen för hur systemleverantörer kan integrera och skicka in e-räkning för assistansersättning för underskrift av användare. Som användare menas den försäkrade, vårdnadshavare eller ställföreträdare.

## Sammanfattning av flödet

Nedan beskrivs en övergripande lösning av flödet för e-tjänsten E-RÄK.

### Del 1 — Presentation av räkning

1. Systemleverantören ger användaren möjlighet att via en knapp eller länk öppna e-tjänsten E-RÄK i en webbläsare.
2. Systemleverantören POST:ar själv in uppgifterna till Försäkringskassan
3. Försäkringskassan validerar uppgifterna och svarar med resultatet av valideringen.
4. Om uppgifterna validerades som korrekta
    1. Försäkringskassan svarar med HTTP 200 och en verifieringskod (`fingerprint`) som identiferar flödet.
    2. Systemleverantören hänvisar användaren (via t.ex. en hyperlänk) till Försäkringsassan tillsammans med detta `fingerprint`.
5. Om uppgifterna valideras felaktigt
    1. Försäkringsassan svarar med HTTP 400 och en JSON-struktur med valideringsfelen.
    2. Systemleverantören väljer själva hur de visar felen.

### Del 2 — Underskrift

Användaren väljer att gå vidare och skriver under räkningen.

1. De underskrivna uppgifterna skickas vidare internt på Försäkringskassan för handläggning.
2. Användaren får en kvittens.

### Del 3 — Rapportering tillbaka till systemleverantören

Det finns två metoder för systemleverantören för att avgöra statusen på den inlämnade räkningen.

1. Användaren följer en länk för att komma tillbaka till systemleverantören.
    - I länken finns en veriferingskod (`fingerprint`) baserad på eräkningen som skickades in.
    - Systemleverantören fick detta `fingerprint` i sitt initiala anrop mot Försäkringskassan. Systemleverantören kan på så vis veta vilket inskick det rör sig om.
2. Försäkringskassan tillhandahåller en endpoint, se separat API-specifikation, som kan anropas för att få status givet ett `fingerprint`.

## Vanliga frågor

Här samlar vi lite vanliga frågor och svar.

### Finns det någon ratelimit på hur ofta/hur många requests vi får göra?

Max 200 inom 60 sekunder, från samma IP-nummer.

### Hur länge lagras ett signeringsflöde. D.v.s. hur långt efter att flödet är påbörjat kommer vi att kunna hämta dess status via /public/v1/status?

2 timmar.

### Vad innebär statusarna?

Vi har en enpoint, enligt separat Openapi-spec, `/public/v1/status` som ger statusen på eräkningen:

- `ABSENT` - Den finns inte. Vi känner inte till den alls.
- `STARTED` - Vi känner till den, vår bild är att flödet pågår.
- `SUCCESSFUL` - Vi har tagit oss igenom flödet signerat. Vår bild är att allting är klart och avslutat.

Vi har `returnUrl` där vi också kommunicerar status på hur kunden tog sig tillbaka:

- `ABORTED` - Kunden klickade på avbryt i Försäkringskassans GUI.
- `SUCCESSFUL` - Kunden klickade på "tillbaka till X" på kvittenssidan. Allting har gått bra och ansökan är inskickad.

### Vad händer med signeringen om användaren beslutar sig för att stänga ner webbläsaren när väl tiden ska signeras?

Sålänge Kund inte signerat kommer ingenting att skickas in till Försäkringskassan. Det går bra att starta ett nytt flöde i efterhand. Då måste man gå hela vägen från början och anropa `create` och sedan `start`.

### Problem kring signering

Om kund upplever problem med att signera så kan det bero på en rad faktorer såsom timeout, tillfälligt tappat kontakten med nätet, gammal webbläsare mm. Be kund prova igen och gärna med annan enhet och/eller webbläsare för att utesluta att det rör sig om något tillfälligt. Hjälper inte detta, kontakta supporten enligt beskrivning under rubriken **Kontakt**.

## Kontakt

Om du som systemleverantör har tekniska frågor om tjänsten. Mejla dina frågor enligt mall nedan.

**Mottagare:**
`svarsulev@forsakringskassan.se`

**Ämne:** `Systemleverantör Assistansersättning`

Beskriv ärendet så tydligt du kan. Om det är en **felrapport** vill vi att nedan information anges.

**Obligatorisk information:**

- `Token`.
- Tidpunkter - När gjordes `create`? När gjordes `start`? o.s.v.
- Fullständig `request`, med eventuell `body`.
- `Fingerprint` - Om man kommit så långt i flödet.

## Öppettiderna

Måndag–fredag: 8–16

Lördag–söndag: stängt

Helgdag: stängt

Om du är assistansanordnare och har frågor om tjänsten ska du vända dig till din systemleverantör.
